/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.M5P;
import weka.core.Capabilities;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.filters.Filter;
import weka.test.Regression;

public abstract class AbstractFilterTest
extends TestCase {
    protected static boolean VERBOSE = false;
    protected Filter m_Filter;
    protected Instances m_Instances;
    protected CheckOptionHandler m_OptionTester;
    protected FilteredClassifier m_FilteredClassifier;
    protected CheckGOE m_GOETester;

    public AbstractFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.m_Filter = this.getFilter();
        this.m_Instances = new Instances(new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("weka/filters/data/FilterTest.arff"))));
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
        this.m_FilteredClassifier = this.getFilteredClassifier();
    }

    @Override
    protected void tearDown() {
        this.m_Filter = null;
        this.m_Instances = null;
        this.m_OptionTester = null;
        this.m_GOETester = null;
        this.m_FilteredClassifier = null;
    }

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        if (this.getFilter() instanceof OptionHandler) {
            result.setOptionHandler((OptionHandler)((Object)this.getFilter()));
        } else {
            result.setOptionHandler(null);
        }
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject(this.getFilter());
        result.setSilent(true);
        return result;
    }

    protected FilteredClassifier getFilteredClassifier() {
        AbstractClassifier cls;
        FilteredClassifier result = new FilteredClassifier();
        Filter filter = this.getFilter();
        result.setFilter(filter);
        if (filter.getCapabilities().handles(Capabilities.Capability.NOMINAL_CLASS)) {
            cls = new J48();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.BINARY_CLASS)) {
            cls = new J48();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.UNARY_CLASS)) {
            cls = new J48();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.NUMERIC_CLASS)) {
            cls = new M5P();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.DATE_CLASS)) {
            cls = new M5P();
        } else {
            throw new IllegalStateException("Cannot determine base classifier for FilteredClassifier!");
        }
        result.setClassifier(cls);
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities(this.m_FilteredClassifier.getClassifier().getCapabilities());
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public abstract Filter getFilter();

    protected Instances useFilter() {
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        try {
            result = Filter.useFilter(icopy, this.m_Filter);
            AbstractFilterTest.assertNotNull(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on useFilter(): \n" + ex.getMessage());
        }
        return result;
    }

    public void testSerialVersionUID() {
        if (SerializationHelper.needsUID(this.m_Filter.getClass())) {
            AbstractFilterTest.fail("Doesn't declare serialVersionUID!");
        }
    }

    public void testBuffered() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        try {
            result = Filter.useFilter(icopy, this.m_Filter);
            AbstractFilterTest.assertNotNull(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on useFilter(): \n" + ex.getMessage());
        }
        StringWriter sw = new StringWriter(2000);
        sw.write(result.toString());
        AbstractFilterTest.assertTrue(icopy.equalHeaders(this.m_Instances));
        AbstractFilterTest.assertEquals(icopy.numInstances(), this.m_Instances.numInstances());
        Instances result2 = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        try {
            result2 = Filter.useFilter(icopy, this.m_Filter);
            AbstractFilterTest.assertNotNull(result2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on useFilter(): \n" + ex.getMessage());
        }
        AbstractFilterTest.assertTrue(icopy.equalHeaders(this.m_Instances));
        AbstractFilterTest.assertEquals(icopy.numInstances(), this.m_Instances.numInstances());
        AbstractFilterTest.assertTrue(result.equalHeaders(result2));
        AbstractFilterTest.assertEquals(result.numInstances(), result2.numInstances());
    }

    public void testIncremental() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        boolean headerImmediate = false;
        try {
            headerImmediate = this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        if (headerImmediate) {
            if (VERBOSE) {
                System.err.println("Filter makes header immediately available.");
            }
            result = this.m_Filter.getOutputFormat();
        }
        int i = 0;
        while (i < icopy.numInstances()) {
            if (VERBOSE) {
                System.err.println("Input instance to filter");
            }
            boolean collectNow = false;
            try {
                collectNow = this.m_Filter.input(icopy.instance(i));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AbstractFilterTest.fail("Exception thrown on input(): \n" + ex.getMessage());
            }
            if (collectNow) {
                if (VERBOSE) {
                    System.err.println("Filter said collect immediately");
                }
                if (!headerImmediate) {
                    AbstractFilterTest.fail("Filter didn't return true from setInputFormat() earlier!");
                }
                if (VERBOSE) {
                    System.err.println("Getting output instance");
                }
                result.add(this.m_Filter.output());
            }
            ++i;
        }
        if (VERBOSE) {
            System.err.println("Setting end of batch");
        }
        boolean toCollect = false;
        try {
            toCollect = this.m_Filter.batchFinished();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on batchFinished(): \n" + ex.getMessage());
        }
        if (toCollect) {
            if (VERBOSE) {
                System.err.println("Filter said collect output");
            }
            if (!headerImmediate) {
                if (VERBOSE) {
                    System.err.println("Getting output format");
                }
                result = this.m_Filter.getOutputFormat();
            }
            if (VERBOSE) {
                System.err.println("Getting output instance");
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
                if (!VERBOSE) continue;
                System.err.println("Getting output instance");
            }
        }
        AbstractFilterTest.assertNotNull(result);
        StringWriter sw = new StringWriter(2000);
        sw.write(result.toString());
    }

    public void testRegression() {
        Regression reg = new Regression(this.getClass());
        Instances result = this.useFilter();
        reg.println(result.toString());
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractFilterTest.fail("Regression test failed. Difference:\n" + diff);
            }
        }
        catch (IOException ex) {
            AbstractFilterTest.fail("Problem during regression testing.\n" + ex);
        }
        reg = new Regression(this.getClass());
        Instances icopy = new Instances(this.m_Instances);
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        try {
            Instance processed;
            int i = 0;
            while (i < icopy.numInstances()) {
                this.m_Filter.input(icopy.instance(i));
                ++i;
            }
            this.m_Filter.batchFinished();
            result = this.m_Filter.getOutputFormat();
            while ((processed = this.m_Filter.output()) != null) {
                result.add(processed);
            }
            AbstractFilterTest.assertNotNull(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on useFilter(): \n" + ex.getMessage());
        }
        reg.println(result.toString());
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractFilterTest.fail("Regression test failed when using deprecated methods. Difference:\n" + diff);
            }
        }
        catch (IOException ex) {
            AbstractFilterTest.fail("Problem during regression testing.\n" + ex);
        }
    }

    public void testThroughput() {
        if (VERBOSE) {
            Instances icopy = new Instances(this.m_Instances);
            Instances result = null;
            int i = 0;
            while (i < 20000) {
                icopy.add(this.m_Instances.instance(i % this.m_Instances.numInstances()));
                ++i;
            }
            long starttime = System.currentTimeMillis();
            boolean headerImmediate = false;
            try {
                headerImmediate = this.m_Filter.setInputFormat(icopy);
                if (headerImmediate) {
                    result = this.m_Filter.getOutputFormat();
                }
                int i2 = 0;
                while (i2 < icopy.numInstances()) {
                    boolean collectNow = false;
                    collectNow = this.m_Filter.input(icopy.instance(i2));
                    if (collectNow) {
                        if (!headerImmediate) {
                            AbstractFilterTest.fail("Filter didn't return true from setInputFormat() earlier!");
                        }
                        result.add(this.m_Filter.output());
                    }
                    ++i2;
                }
                boolean toCollect = false;
                toCollect = this.m_Filter.batchFinished();
                if (toCollect) {
                    if (!headerImmediate) {
                        result = this.m_Filter.getOutputFormat();
                    }
                    while (this.m_Filter.numPendingOutput() > 0) {
                        result.add(this.m_Filter.output());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AbstractFilterTest.fail("Exception thrown during incremental filtering: \n" + ex.getMessage());
            }
            long endtime = System.currentTimeMillis();
            double secs = (double)(endtime - starttime) / 1000.0;
            double rate = (double)icopy.numInstances() / secs;
            System.err.println("\n" + this.m_Filter.getClass().getName() + " incrementally processed " + rate + " instances per sec");
            starttime = System.currentTimeMillis();
            try {
                this.m_Filter.setInputFormat(icopy);
                result = Filter.useFilter(icopy, this.m_Filter);
                AbstractFilterTest.assertNotNull(result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AbstractFilterTest.fail("Exception thrown during batch filtering: \n" + ex.getMessage());
            }
            endtime = System.currentTimeMillis();
            secs = (double)(endtime - starttime) / 1000.0;
            rate = (double)icopy.numInstances() / secs;
            System.err.println("\n" + this.m_Filter.getClass().getName() + " batch processed " + rate + " instances per sec");
        }
    }

    public void testListOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkListOptions()) {
            AbstractFilterTest.fail("Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractFilterTest.fail("setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkDefaultOptions()) {
            AbstractFilterTest.fail("Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkRemainingOptions()) {
            AbstractFilterTest.fail("There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractFilterTest.fail("setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractFilterTest.fail("Resetting of options failed");
        }
    }

    public void testFilteredClassifier() {
        if (this.m_FilteredClassifier == null) {
            return;
        }
        try {
            Instances data = this.getFilteredClassifierData();
            this.m_FilteredClassifier.buildClassifier(data);
            int i = 0;
            while (i < data.numInstances()) {
                this.m_FilteredClassifier.classifyInstance(data.instance(i));
                ++i;
            }
        }
        catch (Exception e) {
            AbstractFilterTest.fail("Problem with FilteredClassifier: " + e.toString());
        }
    }

    public void testBatchFiltering() {
        Instance out;
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            if (this.m_Filter.setInputFormat(icopy)) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (setup)", result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex);
        }
        try {
            int i = 0;
            while (i < icopy.numInstances()) {
                if (this.m_Filter.input(icopy.instance(i))) {
                    out = this.m_Filter.output();
                    AbstractFilterTest.assertNotNull("Instance not made available immediately (1. batch)", out);
                    result.add(out);
                }
                ++i;
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (1. batch)", result);
                AbstractFilterTest.assertTrue("Pending output instances (1. batch)", this.m_Filter.numPendingOutput() > 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown during 1. batch: \n" + ex);
        }
        try {
            result = null;
            if (this.m_Filter.isOutputFormatDefined()) {
                result = this.m_Filter.getOutputFormat();
            }
            int i = 0;
            while (i < icopy.numInstances()) {
                if (this.m_Filter.input(icopy.instance(i))) {
                    if (result == null) {
                        AbstractFilterTest.fail("Filter didn't return true from isOutputFormatDefined() (2. batch)");
                    } else {
                        out = this.m_Filter.output();
                        AbstractFilterTest.assertNotNull("Instance not made available immediately (2. batch)", out);
                        result.add(out);
                    }
                }
                ++i;
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (2. batch)", result);
                AbstractFilterTest.assertTrue("Pending output instances (2. batch)", this.m_Filter.numPendingOutput() > 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown during 2. batch: \n" + ex);
        }
    }

    public void testBatchFilteringSmaller() {
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            if (this.m_Filter.setInputFormat(icopy)) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (setup)", result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex);
        }
        try {
            int i = 0;
            while (i < icopy.numInstances()) {
                if (this.m_Filter.input(icopy.instance(i))) {
                    Instance out = this.m_Filter.output();
                    AbstractFilterTest.assertNotNull("Instance not made available immediately (1. batch)", out);
                    result.add(out);
                }
                ++i;
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (1. batch)", result);
                AbstractFilterTest.assertTrue("Pending output instances (1. batch)", this.m_Filter.numPendingOutput() > 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown during 1. batch: \n" + ex);
        }
        try {
            result = null;
            if (this.m_Filter.isOutputFormatDefined()) {
                result = this.m_Filter.getOutputFormat();
            }
            int num = (int)((double)icopy.numInstances() * 0.3);
            int i = 0;
            while (i < num) {
                icopy.delete(0);
                ++i;
            }
            i = 0;
            while (i < icopy.numInstances()) {
                if (this.m_Filter.input(icopy.instance(i))) {
                    if (result == null) {
                        AbstractFilterTest.fail("Filter didn't return true from isOutputFormatDefined() (2. batch)");
                    } else {
                        Instance out = this.m_Filter.output();
                        AbstractFilterTest.assertNotNull("Instance not made available immediately (2. batch)", out);
                        result.add(out);
                    }
                }
                ++i;
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (2. batch)", result);
                AbstractFilterTest.assertTrue("Pending output instances (2. batch)", this.m_Filter.numPendingOutput() > 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown during 2. batch: \n" + ex);
        }
    }

    public void testBatchFilteringLarger() {
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            if (this.m_Filter.setInputFormat(icopy)) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (setup)", result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown on setInputFormat(): \n" + ex);
        }
        try {
            int i = 0;
            while (i < icopy.numInstances()) {
                if (this.m_Filter.input(icopy.instance(i))) {
                    Instance out = this.m_Filter.output();
                    AbstractFilterTest.assertNotNull("Instance not made available immediately (1. batch)", out);
                    result.add(out);
                }
                ++i;
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (1. batch)", result);
                AbstractFilterTest.assertTrue("Pending output instances (1. batch)", this.m_Filter.numPendingOutput() > 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown during 1. batch: \n" + ex);
        }
        try {
            result = null;
            if (this.m_Filter.isOutputFormatDefined()) {
                result = this.m_Filter.getOutputFormat();
            }
            int num = (int)((double)icopy.numInstances() * 0.3);
            int i = 0;
            while (i < num) {
                icopy.add(icopy.instance(i));
                ++i;
            }
            i = 0;
            while (i < icopy.numInstances()) {
                if (this.m_Filter.input(icopy.instance(i))) {
                    if (result == null) {
                        AbstractFilterTest.fail("Filter didn't return true from isOutputFormatDefined() (2. batch)");
                    } else {
                        Instance out = this.m_Filter.output();
                        AbstractFilterTest.assertNotNull("Instance not made available immediately (2. batch)", out);
                        result.add(out);
                    }
                }
                ++i;
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull("Output format defined (2. batch)", result);
                AbstractFilterTest.assertTrue("Pending output instances (2. batch)", this.m_Filter.numPendingOutput() > 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail("Exception thrown during 2. batch: \n" + ex);
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractFilterTest.fail("No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractFilterTest.fail("Tool tips inconsistent");
        }
    }
}

